#include <windows.h>
#include <stdio.h>
#include "main.h"
#include "xfire.h"

#define xfire_prefs "\x2C\x00\x10\x00\x03\x04\x6C\x61\x6E\x67\x01\x02\x00\x75\x73\x04\x73\x6B\x69\x6E\x01\x05\x00\x58\x66\x69\x72\x65\x05\x74\x68\x65\x6D\x65\x01\x07\x00\x64\x65\x66\x61\x75\x6C\x74"
#define HOST "cs.xfire.com"
#define PORT 25999

#ifdef WIN32
#pragma comment(lib, "ws2_32.lib")
#endif

int main(int argc, char **argv[])
{
	show_banner();
	//check args
	if(argc != 3) {
		return 0;
	}

	strcpy(username, (char*)argv[1]);
	strcpy(password, (char*)argv[2]);

	connect_to_xfire();

}
//---------------------------------------------------------------------
void show_banner()
{
	printf("\
---------------------------------------\n\
Xfire login example by xoclipse\n\
xoclipse@cox.net\n\
http://xoclipse.fraghosts.net\n\
usage: xfire-connect username password\n\
---------------------------------------\n");
}
//---------------------------------------------------------------------
void connect_to_xfire()
{
#ifdef WIN32
	WSAData wsad;
	WSAStartup(MAKEWORD(2,1), &wsad);
#endif
	int sockfd, ret;
	unsigned int uid;
	struct sockaddr_in remote;
	struct hostent *he;
	unsigned char *buf = NULL;
	buf = (unsigned char*)malloc(1024);

	if((sockfd = socket(AF_INET, SOCK_STREAM, IPPROTO_IP)) == -1) {
		perror("socket");
		return;
	}

     if ((he=gethostbyname(HOST)) == NULL) {
            perror("gethostbyname");
            return;
     }

	remote.sin_family = AF_INET;
	remote.sin_port = htons(PORT);
	remote.sin_addr = *((struct in_addr *)he->h_addr);

	connect(sockfd, (struct sockaddr*)&remote, sizeof(remote));
	printf("Connected to Xfire Server.\n");

	//send welcome message
	send(sockfd, WELCOME_MESSAGE, 4, 0);
	printf("Sent welcome message.\n");

	//send version information
	send(sockfd, VERSION_INFO, 18, 0);
	printf("Sent version information.\n");

	//get salt
	ret = recv(sockfd, (char*)buf, 1024, 0);
	printf("Got salt.\n");

	/*for(int x = 0; x < ret; x++) {
		printf("%02X ", buf[x]);
	}
	printf("\n");*/

	char *salt = (char*)malloc(41);
	memcpy(salt, buf+13, 40);
	salt[40] = 0;
	printf("Salt: %s\n", salt);

	/* make login packet */
	unsigned char *login_packet = (unsigned char*)malloc(65+strlen(username));
	unsigned char packet_len[1];
	unsigned char uname_len[1];
	int pos;

	char *encrypted = xfire_encrypt(username, password, salt);

	char blah[] = "d566d28002493b5efa8a3d61de037f01ee210412";
	char part1[] = "\x00\x01\x00\x02\x04""name""\x01";
	char part2[] = "\x08""password""\x01\x28\x00";
	char null1[1];

	null1[0] = 0;
	packet_len[0] = 65+strlen(username);
	uname_len[0] = strlen(username);

	memcpy(login_packet, packet_len, 1);
	pos = 1;
	memcpy(login_packet+pos, part1, 10);
	pos += 10;
	memcpy(login_packet+pos, uname_len, 1);
	pos++;
	memcpy(login_packet+pos, null1, 1);
	pos++;
	memcpy(login_packet+pos, username, strlen(username));
	pos += strlen(username);
	memcpy(login_packet+pos, part2, 12);
	pos += 12;
	memcpy(login_packet+pos, encrypted, 40);

	/*for(int x = 0; x < (65+strlen(username)); x++) printf("%02X ", login_packet[x]);
	printf("\n");*/

	send(sockfd, (char*)login_packet, (65+strlen(username)), 0); 
	printf("Sent login packet(%d bytes).\n", (65+strlen(username)));

	//get response
	ret = recv(sockfd, (char*)buf, 1024, 0);

	if(buf[2] == 0x81) { //invalid user/password
		printf("Invalid Username/Password.\n");
		return;
	}
	
	printf("Logged in, received user information.\n");
	memcpy(&uid, buf+13, 4);
	printf("Our user id: %d.\n", uid);

	send(sockfd, xfire_prefs, 44, 0);
	printf("Sent Preferences.\n");
	printf("We are now online. Our username will appear online to other users.\n");
	for(;;) { //we are onling
#ifdef WIN32
		Sleep(10);
#else
		sleep(10000);
#endif
	}

	if(buf != NULL) free(buf);
}
//----------------------------------------------------------------------
